/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;

public final class QuantifiedIngredient
implements Predicate<ItemStack> {
    private final Ingredient ingredient;
    private final int quantity;

    public static QuantifiedIngredient read(PacketBuffer buffer) {
        return new QuantifiedIngredient(Ingredient.func_199566_b((PacketBuffer)buffer), buffer.func_150792_a());
    }

    public QuantifiedIngredient(Ingredient ingredient, int quantity) {
        this.ingredient = Objects.requireNonNull(ingredient);
        this.quantity = Math.max(0, quantity);
    }

    public QuantifiedIngredient(JsonObject obj) {
        this(Ingredient.func_199802_a((JsonElement)obj.get("ingredient")), Math.max(1, JSONUtils.func_151208_a((JsonObject)obj, (String)"quantity", (int)1)));
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public int getQuantity() {
        return this.quantity;
    }

    @Override
    public boolean test(ItemStack itemStack) {
        return this.ingredient.test(itemStack);
    }

    public JsonElement serialize() {
        JsonObject obj = new JsonObject();
        obj.add("ingredient", this.ingredient.func_200304_c());
        if (this.quantity != 1) {
            obj.addProperty("quantity", (Number)this.quantity);
        }
        return obj;
    }

    public void write(PacketBuffer buffer) {
        this.ingredient.func_199564_a(buffer);
        buffer.func_150787_b(this.quantity);
    }

    public String toString() {
        return "QuantifiedIngredient{ingredient=" + this.ingredient.func_200304_c() + ", quantity=" + this.quantity + '}';
    }
}

